#ifndef GRAPPLE_H
#define GRAPPLE_H

#include <roster.h>
#include <direction.h>

struct GrapplingHook : public Roster {
	Atom *hook;
	Atom *last_atom;
	Link *last_link;
	Atom *head;
	bool *trigger;
	Direction *direction;
	float offset;
	float force;
	int delay;

	GrapplingHook(Object *parent, bool *trigger, Direction *direction = NULL, float offset = 10.0f, float force = -4.0f, Atom *hook = NULL);
	virtual void removeAtom(Atom *a);
	virtual void removeLink(Link *l);
	virtual bool allowRepulse(Atom *a, Atom *b);
	virtual void onRepulse(Atom *a, Atom *b, float force);
	virtual void stepFunc();
	virtual void draw();
};

#endif